/*
 * Decompiled with CFR 0.152.
 */
package dev.zy.sensorboard.processor;

import dev.zy.sensorboard.data.Record;
import dev.zy.sensorboard.processor.Processor;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;

public class HTTPProcessor
implements Processor {
    private String ipAdr;

    public HTTPProcessor(String ipAdr) {
        this.ipAdr = ipAdr;
    }

    public String getIpAdr() {
        return this.ipAdr;
    }

    public void setIpAdr(String ipAdr) {
        this.ipAdr = ipAdr;
    }

    @Override
    public void setWhite(int lv) {
        if (lv == 0) {
            try {
                String info = HTTPProcessor.get("http://" + this.ipAdr + "/setWhite?state=off");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String e = HTTPProcessor.get("http://" + this.ipAdr + "/setWhite?level=" + lv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setUV(int lv) {
        if (lv == 0) {
            try {
                String info = HTTPProcessor.get("http://" + this.ipAdr + "/setUV?state=off");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String e = HTTPProcessor.get("http://" + this.ipAdr + "/setUV?level=" + lv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setScal(int scaling) {
        try {
            String string = HTTPProcessor.get("http://" + this.ipAdr + "/setScal?scaling=" + scaling);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Record getRGB() {
        try {
            Record ret = new Record();
            String info = HTTPProcessor.get("http://" + this.ipAdr + "/getRGB");
            JSONObject ob = new JSONObject(info);
            int r = ob.getJSONObject("value").getInt("R");
            int g = ob.getJSONObject("value").getInt("G");
            int b = ob.getJSONObject("value").getInt("B");
            ret.setR(r);
            ret.setG(g);
            ret.setB(b);
            Date date = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSS");
            ret.setDatetime(formatter.format(date));
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean testConnect() {
        return this.getRGB() != null;
    }

    public static String get(String urlToRead) throws Exception {
        StringBuilder result = new StringBuilder();
        URL url = new URL(urlToRead);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        return result.toString();
    }
}

